<?php
// File: admin/atur_pendaftaran.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
include '../config/koneksi.php';

$tanggal_mulai = '';
$tanggal_selesai = '';
$success = false;

// Ambil data pengaturan jika sudah ada
$result = mysqli_query($conn, "SELECT * FROM setting_pendaftaran LIMIT 1");
if ($row = mysqli_fetch_assoc($result)) {
  $tanggal_mulai = $row['tanggal_mulai'];
  $tanggal_selesai = $row['tanggal_selesai'];
}

// Proses simpan jika form dikirim
if (isset($_POST['submit'])) {
  $tanggal_mulai = $_POST['tanggal_mulai'];
  $tanggal_selesai = $_POST['tanggal_selesai'];

  $cek = mysqli_query($conn, "SELECT COUNT(*) as total FROM setting_pendaftaran");
  $jumlah = mysqli_fetch_assoc($cek)['total'];

  if ($jumlah > 0) {
    $query = "UPDATE setting_pendaftaran SET tanggal_mulai='$tanggal_mulai', tanggal_selesai='$tanggal_selesai' LIMIT 1";
  } else {
    $query = "INSERT INTO setting_pendaftaran (tanggal_mulai, tanggal_selesai) VALUES ('$tanggal_mulai', '$tanggal_selesai')";
  }

  mysqli_query($conn, $query) or die("Gagal menyimpan data: " . mysqli_error($conn));
  $success = true;
}
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Atur Jadwal Pendaftaran</h1>
    </div>
  </div>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">

      <?php if ($success): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          Jadwal pendaftaran berhasil disimpan.
          <button type="button" class="close" data-dismiss="alert" aria-label="Tutup">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      <?php endif; ?>

      <div class="card">
        <div class="card-header">
          <h3 class="card-title">Form Pengaturan Jadwal</h3>
        </div>
        <div class="card-body">
          <form method="post">
            <div class="form-group">
              <label for="tanggal_mulai">Tanggal Mulai Pendaftaran</label>
              <input type="date" name="tanggal_mulai" class="form-control" id="tanggal_mulai" required value="<?= htmlspecialchars($tanggal_mulai) ?>">
            </div>
            <div class="form-group">
              <label for="tanggal_selesai">Tanggal Selesai Pendaftaran</label>
              <input type="date" name="tanggal_selesai" class="form-control" id="tanggal_selesai" required value="<?= htmlspecialchars($tanggal_selesai) ?>">
            </div>
            <button type="submit" name="submit" class="btn btn-primary mt-2">
              <i class="fas fa-save"></i> Simpan
            </button>
          </form>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>