<?php
// File: /admin/cetak.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';

$id = intval($_GET['id']);
$query = mysqli_query($conn, "SELECT * FROM pendaftar WHERE id = $id");
$data = mysqli_fetch_assoc($query);

if (!$data) {
  echo "<script>alert('Data tidak ditemukan'); window.close();</script>";
  exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Bukti Pendaftaran - <?= $data['nama_lengkap']; ?></title>
  <style>
    body { font-family: Arial, sans-serif; margin: 40px; }
    .bukti { border: 1px solid #000; padding: 20px; max-width: 700px; margin: auto; }
    h2 { text-align: center; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    td { padding: 5px; vertical-align: top; }
    .info { margin-top: 30px; }
    .footer { text-align: center; margin-top: 50px; font-size: 14px; }
    @media print { .no-print { display: none; } }
  </style>
</head>
<body>
  <div class="bukti">
    <h2>Bukti Pendaftaran Peserta Didik Baru</h2>
    <hr>
    <table>
      <tr><td width="35%">Nomor Pendaftaran</td><td>: <?= $data['nomor_pendaftaran']; ?></td></tr>
      <tr><td>Nama Lengkap</td><td>: <?= $data['nama_lengkap']; ?></td></tr>
      <tr><td>Tempat, Tanggal Lahir</td><td>: <?= $data['tempat_lahir']; ?>, <?= date('d-m-Y', strtotime($data['tanggal_lahir'])); ?></td></tr>
      <tr><td>NIK</td><td>: <?= $data['nik']; ?></td></tr>
      <tr><td>NISN</td><td>: <?= $data['nisn']; ?></td></tr>
      <tr><td>Jenis Kelamin</td><td>: <?= $data['jenis_kelamin']; ?></td></tr>
      <tr><td>Alamat</td><td>: <?= $data['alamat']; ?></td></tr>
      <tr><td>Asal Sekolah</td><td>: <?= $data['sekolah_asal']; ?></td></tr>
      <tr><td>No. HP</td><td>: <?= $data['no_hp']; ?></td></tr>
      <tr><td>Status Pendaftar</td><td>: <strong><?= $data['status']; ?></strong></td></tr>
    </table>

    <div class="info">
      <p>Harap simpan bukti ini sebagai referensi saat verifikasi ulang atau pengumuman hasil seleksi.</p>
    </div>

    <div class="footer">
      <p>Dicetak pada: <?= date('d-m-Y H:i'); ?></p>
    </div>
  </div>

  <div class="text-center no-print" style="text-align:center; margin-top: 30px;">
    <button onclick="window.print()">🖨 Cetak Bukti</button>
    <button onclick="window.close()">❌ Tutup</button>
  </div>
</body>
</html>