<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
include '../config/koneksi.php';

// Statistik
$total = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as jml FROM pendaftar"))['jml'];
$diterima = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as jml FROM pendaftar WHERE status = 'Diterima'"))['jml'];
$cadangan = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as jml FROM pendaftar WHERE status = 'Cadangan'"))['jml'];
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Admin</h1>
      <div class="alert alert-success mt-3">
        Selamat datang, <?= htmlspecialchars($_SESSION['admin']['nama_lengkap']); ?>!
      </div>
    </div>
  </div>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">

      <!-- Statistik -->
      <div class="row">
        <div class="col-md-4">
          <div class="small-box bg-primary">
            <div class="inner">
              <h3><?= $total ?></h3>
              <p>Total Pendaftar</p>
            </div>
            <div class="icon">
              <i class="fas fa-users"></i>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="small-box bg-success">
            <div class="inner">
              <h3><?= $diterima ?></h3>
              <p>Diterima</p>
            </div>
            <div class="icon">
              <i class="fas fa-check-circle"></i>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="small-box bg-warning">
            <div class="inner">
              <h3><?= $cadangan ?></h3>
              <p>Cadangan</p>
            </div>
            <div class="icon">
              <i class="fas fa-clock"></i>
            </div>
          </div>
        </div>
      </div>

      <!-- Chart -->
      <div class="row">
        <div class="col-lg-6">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Grafik Batang PPDB</h3>
            </div>
            <div class="card-body">
              <canvas id="barChart"></canvas>
            </div>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Grafik Pie PPDB</h3>
            </div>
            <div class="card-body">
              <canvas id="pieChart"></canvas>
            </div>
          </div>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>

<!-- Chart.js -->
<script src="assets/adminLTE/plugins/chart.js/Chart.min.js"></script>

<script>
  const total = <?= $total ?>;
  const diterima = <?= $diterima ?>;
  const cadangan = <?= $cadangan ?>;

  new Chart(document.getElementById('barChart'), {
    type: 'bar',
    data: {
      labels: ['Total', 'Diterima', 'Cadangan'],
      datasets: [{
        label: 'Jumlah',
        data: [total, diterima, cadangan],
        backgroundColor: ['#007bff', '#28a745', '#ffc107']
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: false }
      }
    }
  });

  new Chart(document.getElementById('pieChart'), {
    type: 'pie',
    data: {
      labels: ['Total', 'Diterima', 'Cadangan'],
      datasets: [{
        data: [total, diterima, cadangan],
        backgroundColor: ['#007bff', '#28a745', '#ffc107']
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'bottom' }
      }
    }
  });
</script>