<?php
// File: /admin/data_pendaftar.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
include '../config/koneksi.php';

$query = mysqli_query($conn, "SELECT * FROM pendaftar ORDER BY id DESC");
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Data Pendaftar</h1>
    </div>
  </div>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">

      <div class="card">
        <div class="card-header">
          <h3 class="card-title">Tabel Pendaftar</h3>
        </div>
        <div class="card-body table-responsive">
          <table class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>No</th>
                <th>No. Pendaftaran</th>
                <th>Nama</th>
                <th>NIK</th>
                <th>Status</th>
                <th>Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php $no = 1; while ($row = mysqli_fetch_assoc($query)) : ?>
              <tr>
                <td><?= $no++; ?></td>
                <td><?= $row['nomor_pendaftaran']; ?></td>
                <td><?= $row['nama_lengkap']; ?></td>
                <td><?= $row['nik']; ?></td>
                <td>
                  <span class="badge 
                    <?= $row['status'] === 'Diterima' ? 'badge-success' : 
                        ($row['status'] === 'Cadangan' ? 'badge-warning' : 'badge-secondary') ?>">
                    <?= $row['status']; ?>
                  </span>
                </td>
                <td>
                  <a href="lihat_pendaftar.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-info">
                    <i class="fas fa-eye"></i> Lihat
                  </a>
                  <a href="ubah_status.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-warning">
                    <i class="fas fa-edit"></i> Status
                  </a>
                  <a href="cetak.php?id=<?= $row['id']; ?>" target="_blank" class="btn btn-sm btn-success">
                    <i class="fas fa-print"></i> Cetak
                  </a>
                  <a href="hapus_pendaftar.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus data ini?')">
                    <i class="fas fa-trash"></i> Hapus
                  </a>
                </td>
              </tr>
              <?php endwhile; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>
<!-- /.content-wrapper -->

<?php include 'partials/footer.php'; ?>