<?php
// File: admin/diterima.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';
include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';

// Ambil data pengaturan pengumuman
$pengaturan = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM pengaturan_pengumuman LIMIT 1"));
$link_wa = $pengaturan['link_grup_wa'] ?? '';
$nomor_panitia = $pengaturan['nomor_panitia'] ?? '';

// Ambil data pendaftar diterima
$data = mysqli_query($conn, "SELECT nomor_pendaftaran, nama_lengkap, nik FROM pendaftar WHERE status = 'diterima' ORDER BY id DESC");
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="d-flex justify-content-between align-items-center">
        <h1 class="m-0">Pendaftar Diterima</h1>
        <a href="export_diterima.php" class="btn btn-success btn-sm">
          <i class="fas fa-file-excel"></i> Export Excel
        </a>
      </div>
    </div>
  </section>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">

      <!-- Pengaturan Pengumuman -->
      <div class="card mb-4">
        <div class="card-header">
          <h3 class="card-title">Pengaturan Link WhatsApp & Kontak Panitia</h3>
        </div>
        <div class="card-body">
          <form action="simpan_pengumuman.php" method="POST">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="link_grup_wa">Link Grup WhatsApp</label>
                  <input type="url" name="link_grup_wa" id="link_grup_wa" class="form-control" placeholder="https://chat.whatsapp.com/..." value="<?= htmlspecialchars($link_wa) ?>">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="nomor_panitia">Nomor WhatsApp Panitia</label>
                  <input type="text" name="nomor_panitia" id="nomor_panitia" class="form-control" placeholder="08xxxxxxxxxx" value="<?= htmlspecialchars($nomor_panitia) ?>">
                </div>
              </div>
            </div>
            <button type="submit" class="btn btn-primary mt-2">Simpan Pengaturan</button>
            <p class="text-muted mt-2 mb-0"><small>* Pengaturan ini akan tampil di halaman pengumuman frontend.</small></p>
          </form>
        </div>
      </div>

      <!-- Tabel Pendaftar Diterima -->
      <div class="card">
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm">
              <thead class="thead-light">
                <tr>
                  <th>No</th>
                  <th>No. Pendaftaran</th>
                  <th>Nama Lengkap</th>
                  <th>NIK</th>
                </tr>
              </thead>
              <tbody>
                <?php $no = 1; while ($row = mysqli_fetch_assoc($data)) : ?>
                  <tr>
                    <td><?= $no++ ?></td>
                    <td><?= htmlspecialchars($row['nomor_pendaftaran']) ?></td>
                    <td><?= htmlspecialchars($row['nama_lengkap']) ?></td>
                    <td><?= htmlspecialchars($row['nik']) ?></td>
                  </tr>
                <?php endwhile; ?>
                <?php if (mysqli_num_rows($data) === 0): ?>
                  <tr>
                    <td colspan="4" class="text-center text-muted">Belum ada data pendaftar diterima.</td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>