<?php
// File: admin/edit_faq.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';
include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';

$id = intval($_GET['id']);
$data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM faq WHERE id = $id"));

if (!$data) {
  echo "<script>alert('Data tidak ditemukan'); window.location='faq.php';</script>";
  exit;
}

if (isset($_POST['submit'])) {
  $pertanyaan = mysqli_real_escape_string($conn, $_POST['pertanyaan']);
  $jawaban = mysqli_real_escape_string($conn, $_POST['jawaban']);
  mysqli_query($conn, "UPDATE faq SET pertanyaan = '$pertanyaan', jawaban = '$jawaban' WHERE id = $id");
  header("Location: faq.php?edit_success=1");
  exit;
}
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="d-flex justify-content-between align-items-center">
        <h1 class="m-0">Edit FAQ</h1>
        <a href="faq.php" class="btn btn-secondary btn-sm">
          <i class="fas fa-arrow-left"></i> Kembali
        </a>
      </div>
    </div>
  </section>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <form method="post">
            <div class="form-group">
              <label for="pertanyaan">Pertanyaan</label>
              <input type="text" name="pertanyaan" id="pertanyaan" class="form-control" value="<?= htmlspecialchars($data['pertanyaan']) ?>" required>
            </div>
            <div class="form-group mt-3">
              <label for="jawaban">Jawaban</label>
              <textarea name="jawaban" id="jawaban" class="form-control" rows="4" required><?= htmlspecialchars($data['jawaban']) ?></textarea>
            </div>
            <div class="mt-4">
              <button type="submit" name="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Simpan Perubahan
              </button>
              <a href="faq.php" class="btn btn-secondary ms-2">Batal</a>
            </div>
          </form>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>