<?php
// File: admin/faq.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';
$data = mysqli_query($conn, "SELECT * FROM faq ORDER BY id ASC");

include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <section class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Kelola FAQ</h1>
    </div>
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <?php if (isset($_GET['edit_success'])) : ?>
        <div class="alert alert-success alert-dismissible fade show">
          FAQ berhasil diperbarui.
          <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
      <?php endif; ?>

      <a href="tambah_faq.php" class="btn btn-primary mb-3">Tambah FAQ</a>

      <div class="card">
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-bordered table-striped">
              <thead class="thead-light">
                <tr>
                  <th width="5%">#</th>
                  <th>Pertanyaan</th>
                  <th>Jawaban</th>
                  <th width="15%">Aksi</th>
                </tr>
              </thead>
              <tbody>
                <?php $no = 1; while ($row = mysqli_fetch_assoc($data)) : ?>
                  <tr>
                    <td><?= $no++ ?></td>
                    <td><?= htmlspecialchars($row['pertanyaan']) ?></td>
                    <td><?= nl2br(htmlspecialchars($row['jawaban'])) ?></td>
                    <td>
                      <a href="edit_faq.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">
                        <i class="fas fa-edit"></i> Edit
                      </a>
                      <a href="hapus_faq.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus?')">
                        <i class="fas fa-trash-alt"></i> Hapus
                      </a>
                    </td>
                  </tr>
                <?php endwhile; ?>
                <?php if (mysqli_num_rows($data) === 0): ?>
                  <tr>
                    <td colspan="4" class="text-center">Belum ada data FAQ.</td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>