<?php
// File: /admin/lihat_pendaftar.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
include '../config/koneksi.php';

$id = intval($_GET['id']);
$query = mysqli_query($conn, "SELECT * FROM pendaftar WHERE id = $id");
$data = mysqli_fetch_assoc($query);
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Detail Pendaftar</h1>
    </div>
  </div>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">

      <?php if ($data): ?>
      <div class="card">
        <div class="card-body">
          <table class="table table-bordered">
            <tr><th>Nomor Pendaftaran</th><td><?= $data['nomor_pendaftaran'] ?></td></tr>
            <tr><th>Nama Lengkap</th><td><?= $data['nama_lengkap'] ?></td></tr>
            <tr><th>NISN</th><td><?= $data['nisn'] ?></td></tr>
            <tr><th>NIK</th><td><?= $data['nik'] ?></td></tr>
            <tr><th>Tempat, Tanggal Lahir</th><td><?= $data['tempat_lahir'] . ", " . date('d-m-Y', strtotime($data['tanggal_lahir'])) ?></td></tr>
            <tr><th>Usia</th><td><?= $data['usia'] ?></td></tr>
            <tr><th>Jenis Kelamin</th><td><?= $data['jenis_kelamin'] ?></td></tr>
            <tr><th>Alamat</th><td><?= $data['alamat'] ?></td></tr>
            <tr><th>Sekolah Asal</th><td><?= $data['sekolah_asal'] ?></td></tr>
            <tr><th>No HP</th><td><?= $data['no_hp'] ?></td></tr>
            <tr><th>Nama Ayah</th><td><?= $data['nama_ayah'] ?></td></tr>
            <tr><th>Nama Ibu</th><td><?= $data['nama_ibu'] ?></td></tr>
            <tr><th>Pekerjaan Ayah</th><td><?= $data['pekerjaan_ayah'] ?></td></tr>
            <tr><th>Pekerjaan Ibu</th><td><?= $data['pekerjaan_ibu'] ?></td></tr>
            <tr><th>Status Ayah</th><td><?= $data['status_ayah'] ?></td></tr>
            <tr><th>Status Ibu</th><td><?= $data['status_ibu'] ?></td></tr>

            <tr><th>Kartu Keluarga</th><td>
              <?php if (!empty($data['file_kk']) && file_exists($_SERVER['DOCUMENT_ROOT'] . "/uploads/" . $data['file_kk'])): ?>
                <a href="/uploads/<?= $data['file_kk'] ?>" target="_blank" class="btn btn-sm btn-outline-primary">Lihat File</a>
              <?php else: ?>
                <span class="text-danger">File tidak ditemukan</span>
              <?php endif; ?>
            </td></tr>

            <tr><th>Akte Kelahiran</th><td>
              <?php if (!empty($data['file_akte']) && file_exists($_SERVER['DOCUMENT_ROOT'] . "/uploads/" . $data['file_akte'])): ?>
                <a href="/uploads/<?= $data['file_akte'] ?>" target="_blank" class="btn btn-sm btn-outline-primary">Lihat File</a>
              <?php else: ?>
                <span class="text-danger">File tidak ditemukan</span>
              <?php endif; ?>
            </td></tr>

            <tr><th>KTP Orang Tua</th><td>
              <?php if (!empty($data['file_ktp']) && file_exists($_SERVER['DOCUMENT_ROOT'] . "/uploads/" . $data['file_ktp'])): ?>
                <a href="/uploads/<?= $data['file_ktp'] ?>" target="_blank" class="btn btn-sm btn-outline-primary">Lihat File</a>
              <?php else: ?>
                <span class="text-danger">File tidak ditemukan</span>
              <?php endif; ?>
            </td></tr>

            <tr><th>Sertifikat (Opsional)</th><td>
              <?php if (!empty($data['file_sertifikat']) && file_exists($_SERVER['DOCUMENT_ROOT'] . "/uploads/" . $data['file_sertifikat'])): ?>
                <a href="/uploads/<?= $data['file_sertifikat'] ?>" target="_blank" class="btn btn-sm btn-outline-primary">Lihat File</a>
              <?php else: ?>
                <span class="text-muted">-</span>
              <?php endif; ?>
            </td></tr>
          </table>

          <a href="data_pendaftar.php" class="btn btn-secondary mt-3">
            <i class="fas fa-arrow-left"></i> Kembali
          </a>
        </div>
      </div>

      <?php else: ?>
        <div class="alert alert-danger">Data tidak ditemukan.</div>
      <?php endif; ?>

    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>