<?php
session_start();
include '../config/koneksi.php'; // karena login.php ada di /admin/

// Ambil setting
$setting = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM setting LIMIT 1"));

// Path untuk cek file di server
$serverLogoPath = __DIR__ . '/../uploads/logo/';  // naik 1 folder dari /admin/
// Path untuk URL web
$webLogoPath    = '/uploads/logo/';

// Tentukan logo
if (!empty($setting['logo']) && file_exists($serverLogoPath . $setting['logo'])) {
    $logo = $webLogoPath . $setting['logo'];
} else {
    $logo = $webLogoPath . 'default.png';
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <title>Login Admin</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

  <!-- Feather Icons -->
  <script src="https://unpkg.com/feather-icons"></script>

  <style>
    body {
      font-family: 'Poppins', sans-serif;
      margin: 0;
      padding: 0;
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      background: linear-gradient(135deg, #007bff, #00c6ff);
    }
    .login-container {
      background: #fff;
      padding: 2rem 2.5rem;
      border-radius: 16px;
      box-shadow: 0 6px 20px rgba(0,0,0,0.12);
      width: 100%;
      max-width: 380px;
      animation: fadeIn 0.8s ease;
    }
    @keyframes fadeIn {
      from {opacity: 0; transform: translateY(20px);}
      to {opacity: 1; transform: translateY(0);}
    }
    .login-header {
      text-align: center;
      margin-bottom: 1.8rem;
    }
    .login-header img {
      max-width: 90px;
      margin-bottom: 12px;
    }
    .login-header h1 {
      font-size: 1.5rem;
      margin: 0;
      color: #222;
    }
    .login-header p {
      margin: 4px 0 0;
      font-size: 0.9rem;
      color: #666;
    }
    .form-group {
      margin-bottom: 1.2rem;
    }
    .input-group {
      display: flex;
      align-items: center;
      border: 1px solid #ddd;
      border-radius: 8px;
      padding: 0.55rem 0.75rem;
      background: #fafafa;
      transition: border 0.3s, box-shadow 0.3s;
    }
    .input-group:focus-within {
      border-color: #007bff;
      box-shadow: 0 0 0 3px rgba(0,123,255,0.15);
    }
    .input-group i {
      margin-right: 8px;
      color: #888;
    }
    .input-group input {
      border: none;
      outline: none;
      background: transparent;
      flex: 1;
      font-size: 0.95rem;
      color: #333;
    }
    .form-check {
      font-size: 0.85rem;
      color: #555;
      margin-top: 0.6rem; /* jarak antara input password dan checkbox */
    }
    .form-check-input {
      margin-right: 6px; /* jarak antara checkbox & teks */
    }
    .btn-login {
      width: 100%;
      padding: 0.75rem;
      border: none;
      border-radius: 8px;
      background: linear-gradient(135deg, #007bff, #00c6ff);
      color: #fff;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s;
      box-shadow: 0 4px 10px rgba(0,123,255,0.25);
    }
    .btn-login:hover {
      transform: translateY(-1px);
      box-shadow: 0 6px 14px rgba(0,123,255,0.3);
    }
    .alert {
      padding: 0.75rem 1rem;
      border-radius: 8px;
      margin-bottom: 1rem;
      font-size: 0.9rem;
    }
    .alert-danger {
      background: #f8d7da;
      color: #721c24;
      border: 1px solid #f5c6cb;
    }
    .login-footer {
      text-align: center;
      margin-top: 1.2rem;
      font-size: 0.8rem;
      color: #999;
    }
    @media (max-width: 480px) {
      .login-container {
        padding: 1.5rem;
        border-radius: 12px;
      }
      .login-header img {
        max-width: 70px;
      }
    }
  </style>
</head>
<body>
  <div class="login-container">
    <div class="login-header">
      <img src="<?= $logo ?>" alt="Logo">
      <h1>Login Admin</h1>
      <?php if (!empty($setting['nama_madrasah'])): ?>
        <p><?= htmlspecialchars($setting['nama_madrasah']); ?></p>
      <?php endif; ?>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
      <div class="alert alert-danger">
        <?= $_SESSION['error']; unset($_SESSION['error']); ?>
      </div>
    <?php endif; ?>

    <form action="proses_login.php" method="post">
      <div class="form-group">
        <div class="input-group">
          <i data-feather="mail"></i>
          <input type="email" name="email" placeholder="Masukkan email" required>
        </div>
      </div>
      <div class="form-group">
        <div class="input-group">
          <i data-feather="lock"></i>
          <input type="password" name="password" id="password" placeholder="Masukkan password" required>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="checkbox" id="showPassword" onclick="togglePassword()">
          <label class="form-check-label" for="showPassword">
            Tampilkan Password
          </label>
        </div>
      </div>
      <button type="submit" class="btn-login">Login</button>

      <!-- Footer Copyright -->
      <div class="login-footer">
        &copy; <?= date('Y') ?> <?= !empty($setting['nama_madrasah']) ? htmlspecialchars($setting['nama_madrasah']) : 'Madrasah' ?>. All rights reserved.
      </div>
    </form>
  </div>

  <script>
    feather.replace();
    function togglePassword() {
      const password = document.getElementById("password");
      password.type = password.type === "password" ? "text" : "password";
    }
  </script>
</body>
</html>