<?php
session_start();
include '../config/koneksi.php';

// Cek login
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

// Ambil data admin
$id = $_SESSION['admin']['id'];
$query = mysqli_query($conn, "SELECT * FROM admin WHERE id = '$id'");
$data = mysqli_fetch_assoc($query);
?>

<?php include 'partials/header.php'; ?>
<?php include 'partials/topbar.php'; ?>

<div class="wrapper">
  <!-- Sidebar -->
  <?php include 'partials/sidebar.php'; ?>

  <!-- Content Wrapper -->
  <div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
      <div class="container-fluid">
        <h3 class="mb-0">Profil Pengguna</h3>
      </div>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        
        <!-- Notifikasi -->
        <?php if (isset($_SESSION['success'])): ?>
          <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= $_SESSION['success']; unset($_SESSION['success']); ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
          </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $_SESSION['error']; unset($_SESSION['error']); ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
          </div>
        <?php endif; ?>

        <!-- Konten Dua Kolom -->
        <div class="row">
          <!-- Kolom Kiri: Foto & Identitas -->
          <div class="col-md-5">
            <div class="card shadow-sm">
              <div class="card-body text-center">
                <table class="table table-borderless text-start">
                  <tr>
                    <th style="width: 120px;">Nama</th>
                    <td><?= htmlspecialchars($data['nama_lengkap']) ?></td>
                  </tr>
                  <tr>
                    <th>Email</th>
                    <td><?= htmlspecialchars($data['email']) ?></td>
                  </tr>
                </table>
              </div>
            </div>
          </div>

          <!-- Kolom Kanan: Form Ganti Password -->
          <div class="col-md-7">
            <div class="card shadow-sm">
              <div class="card-header bg-primary text-white">
                <h5 class="card-title mb-0">Ganti Password</h5>
              </div>
              <div class="card-body">
                <form action="proses_ganti_password.php" method="post">
                  <div class="form-group mb-3">
                    <label>Password Lama</label>
                    <input type="password" name="password_lama" class="form-control" required>
                  </div>
                  <div class="form-group mb-3">
                    <label>Password Baru</label>
                    <input type="password" name="password_baru" class="form-control" required>
                  </div>
                  <div class="form-group mb-3">
                    <label>Konfirmasi Password Baru</label>
                    <input type="password" name="konfirmasi_password" class="form-control" required>
                  </div>
                  <button type="submit" class="btn btn-success">Simpan Perubahan</button>
                </form>
              </div>
            </div>
          </div>
        </div>

      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <!-- Footer -->
  <?php include 'partials/footer.php'; ?>
</div>
<!-- ./wrapper -->