<?php
// File: admin/section_about.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';

// Proses simpan sebelum ada output HTML
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
  $judul_kecil = $_POST['judul_kecil'];
  $judul_besar = $_POST['judul_besar'];
  $deskripsi   = $_POST['deskripsi'];
  $daftar      = $_POST['daftar'];
  $text_link   = $_POST['text_link'];

  // Upload gambar
  $uploadDir = '../halaman/assets/img/about/';
  $data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM section_about LIMIT 1"));

  $gambar1 = !empty($_FILES['gambar1']['name']) ? uniqid() . '-' . basename($_FILES['gambar1']['name']) : $data['gambar1'];
  $gambar2 = !empty($_FILES['gambar2']['name']) ? uniqid() . '-' . basename($_FILES['gambar2']['name']) : $data['gambar2'];
  $gambar3 = !empty($_FILES['gambar3']['name']) ? uniqid() . '-' . basename($_FILES['gambar3']['name']) : $data['gambar3'];

  if ($_FILES['gambar1']['tmp_name']) move_uploaded_file($_FILES['gambar1']['tmp_name'], $uploadDir . $gambar1);
  if ($_FILES['gambar2']['tmp_name']) move_uploaded_file($_FILES['gambar2']['tmp_name'], $uploadDir . $gambar2);
  if ($_FILES['gambar3']['tmp_name']) move_uploaded_file($_FILES['gambar3']['tmp_name'], $uploadDir . $gambar3);

  // Simpan data
  $query = "UPDATE section_about SET 
    judul_kecil='$judul_kecil',
    judul_besar='$judul_besar',
    deskripsi='$deskripsi',
    daftar='$daftar',
    text_link='$text_link',
    gambar1='$gambar1',
    gambar2='$gambar2',
    gambar3='$gambar3'
    WHERE id = 1";
  mysqli_query($conn, $query);
  header("Location: section_about.php?success=1");
  exit;
}

// Setelah header selesai baru load layout
include 'partials/header.php';
include 'partials/sidebar.php';
include 'partials/navbar.php';

// Ambil data section
$data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM section_about LIMIT 1"));
?>

<div class="content-wrapper">
  <!-- Content Header (judul halaman) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Kelola Section Tentang Kami</h1>
        </div>
      </div>
      <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show mt-2" role="alert">
          Perubahan berhasil disimpan.
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      <?php endif; ?>
    </div>
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">

      <div class="card card-primary">
        <div class="card-header">
          <h3 class="card-title">Form Tentang Kami</h3>
        </div>

        <form method="post" enctype="multipart/form-data">
          <div class="card-body">
            <div class="row">
              <!-- Kolom kiri -->
              <div class="col-md-6">
                <div class="form-group">
                  <label>Judul Kecil</label>
                  <input type="text" name="judul_kecil" class="form-control" value="<?= htmlspecialchars($data['judul_kecil']) ?>">
                </div>
                <div class="form-group">
                  <label>Judul Besar</label>
                  <input type="text" name="judul_besar" class="form-control" value="<?= htmlspecialchars($data['judul_besar']) ?>">
                </div>
                <div class="form-group">
                  <label>Deskripsi (italik)</label>
                  <textarea name="deskripsi" class="form-control" rows="3"><?= htmlspecialchars($data['deskripsi']) ?></textarea>
                </div>
                <div class="form-group">
                  <label>Text Link</label>
                  <input type="text" name="text_link" class="form-control" value="<?= htmlspecialchars($data['text_link']) ?>">
                </div>
              </div>

              <!-- Kolom kanan -->
              <div class="col-md-6">
                <div class="form-group">
                  <label>Daftar Poin (pisahkan dengan baris baru)</label>
                  <textarea name="daftar" class="form-control" rows="5"><?= htmlspecialchars($data['daftar']) ?></textarea>
                </div>

                <?php for ($i = 1; $i <= 3; $i++): ?>
                  <div class="form-group">
                    <label>Gambar <?= $i ?></label>
                    <input type="file" name="gambar<?= $i ?>" class="form-control-file">
                    <?php if ($data["gambar$i"]): ?>
                      <small class="d-block text-muted">File saat ini: <?= $data["gambar$i"] ?></small>
                      <img src="../halaman/assets/img/about/<?= $data["gambar$i"] ?>" class="img-thumbnail mt-1" width="120">
                    <?php endif; ?>
                  </div>
                <?php endfor; ?>
              </div>
            </div>
          </div>

          <div class="card-footer text-right">
            <button type="submit" name="submit" class="btn btn-primary">
              <i class="fas fa-save"></i> Simpan
            </button>
          </div>
        </form>
      </div>

    </div>
  </section>
</div> <!-- /.content-wrapper -->

<?php include 'partials/footer.php'; ?>