<?php
// File: admin/section_cta.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';

// Ambil data CTA
$data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM section_cta LIMIT 1"));

// Proses form
if (isset($_POST['submit'])) {
  $judul     = $_POST['judul'];
  $deskripsi = $_POST['deskripsi'];
  $link      = $_POST['link'];

  $gambar = $data['gambar'];

  // Jika upload gambar baru
  if ($_FILES['gambar']['name']) {
    $ext = strtolower(pathinfo($_FILES['gambar']['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg', 'jpeg', 'png', 'webp'];

    if (in_array($ext, $allowed)) {
      $namaBaru = 'cta_' . date('Ymd_His') . '_' . uniqid() . '.' . $ext;
      $target = '../halaman/assets/img/cta/' . $namaBaru;

      if (move_uploaded_file($_FILES['gambar']['tmp_name'], $target)) {
        if ($data['gambar'] && file_exists('../halaman/assets/img/cta/' . $data['gambar'])) {
          unlink('../halaman/assets/img/cta/' . $data['gambar']);
        }
        $gambar = $namaBaru;
      }
    }
  }

  mysqli_query($conn, "UPDATE section_cta SET judul='$judul', deskripsi='$deskripsi', link='$link', gambar='$gambar' WHERE id=1");
  header("Location: section_cta.php?success=1");
  exit;
}

// Include tampilan
include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <section class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Kelola Call To Action (CTA)</h1>
    </div>
  </section>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">
      <?php if (isset($_GET['success'])) : ?>
        <div class="alert alert-success alert-dismissible fade show">
          Perubahan berhasil disimpan.
          <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
      <?php endif; ?>

      <div class="card">
        <div class="card-body">
          <form method="post" enctype="multipart/form-data">
            <div class="form-group">
              <label>Judul</label>
              <input type="text" name="judul" class="form-control" required value="<?= htmlspecialchars($data['judul']) ?>">
            </div>

            <div class="form-group">
              <label>Deskripsi</label>
              <textarea name="deskripsi" class="form-control" rows="4" required><?= htmlspecialchars($data['deskripsi']) ?></textarea>
            </div>

            <div class="form-group">
              <label>Link Tombol</label>
              <input type="text" name="link" class="form-control" required value="<?= htmlspecialchars($data['link']) ?>">
            </div>

            <div class="form-group">
              <label>Gambar CTA</label><br>
              <?php if ($data['gambar']) : ?>
                <img src="../halaman/assets/img/cta/<?= $data['gambar'] ?>" alt="Gambar CTA" class="img-thumbnail mb-2" style="max-width: 250px">
              <?php endif; ?>
              <input type="file" name="gambar" class="form-control">
              <small class="text-muted">Format: jpg, jpeg, png, webp</small>
            </div>

            <button type="submit" name="submit" class="btn btn-primary">Simpan</button>
          </form>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>