<?php
// File: admin/section_galeri.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';

// Ambil data galeri
$galeri = mysqli_query($conn, "SELECT * FROM portofolio ORDER BY id DESC");

// Load tampilan
include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <section class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Kelola Galeri</h1>
    </div>
  </section>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">

      <!-- Notifikasi -->
      <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          Gambar berhasil ditambahkan.
          <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
      <?php elseif (isset($_GET['deleted'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          Gambar berhasil dihapus.
          <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
      <?php endif; ?>

      <div class="mb-3">
        <a href="tambah_galeri.php" class="btn btn-primary">
          <i class="fas fa-plus"></i> Tambah Gambar
        </a>
      </div>

      <!-- Galeri -->
      <div class="row">
        <?php if (mysqli_num_rows($galeri) > 0): ?>
          <?php while ($row = mysqli_fetch_assoc($galeri)) :
            $gambarPath = '../halaman/assets/img/portofolio/' . htmlspecialchars($row['gambar']);
          ?>
            <div class="col-md-4 col-sm-6 mb-4">
              <div class="card border shadow-sm">
                <img src="<?= $gambarPath ?>" class="card-img-top" alt="Galeri" style="height: 200px; object-fit: cover; cursor: pointer;"
                  data-toggle="modal" data-target="#previewModal" data-src="<?= $gambarPath ?>">
                <div class="card-body text-center p-2">
                  <small class="text-muted d-block mb-2"><?= htmlspecialchars($row['gambar']) ?></small>
                  <a href="hapus_galeri.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger"
                     onclick="return confirm('Yakin ingin menghapus gambar ini?')">
                    <i class="fas fa-trash"></i> Hapus
                  </a>
                </div>
              </div>
            </div>
          <?php endwhile; ?>
        <?php else: ?>
          <div class="col-12">
            <div class="alert alert-info">Belum ada gambar di galeri.</div>
          </div>
        <?php endif; ?>
      </div>

    </div>
  </section>
</div>

<!-- Modal Preview Gambar -->
<div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-body p-0">
        <img src="" id="modalImage" class="img-fluid w-100" alt="Preview">
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const modalImage = document.getElementById('modalImage');
    const galleryImages = document.querySelectorAll('[data-target="#previewModal"]');

    galleryImages.forEach(img => {
      img.addEventListener('click', function () {
        const src = this.getAttribute('data-src');
        modalImage.setAttribute('src', src);
      });
    });
  });
</script>

<?php include 'partials/footer.php'; ?>