<?php
// File: admin/section_keunggulan.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';

// Ambil data keunggulan dari database
$keunggulan = mysqli_query($conn, "SELECT * FROM section_keunggulan ORDER BY id ASC");

// Layout tampilan
include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Kelola Keunggulan Madrasah</h1>
    </div>
  </div>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">

      <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          Data berhasil disimpan.
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      <?php elseif (isset($_GET['deleted'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          Data berhasil dihapus.
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      <?php endif; ?>

      <div class="mb-3">
        <a href="form_keunggulan.php" class="btn btn-primary">
          <i class="fas fa-plus"></i> Tambah Keunggulan
        </a>
      </div>

      <div class="card">
        <div class="card-body table-responsive">
          <table class="table table-bordered table-striped">
            <thead class="thead-light">
              <tr>
                <th style="width: 50px;">#</th>
                <th style="width: 80px;">Icon</th>
                <th>Judul</th>
                <th>Deskripsi</th>
                <th style="width: 150px;">Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php $no = 1; while ($row = mysqli_fetch_assoc($keunggulan)) : ?>
                <tr>
                  <td><?= $no++ ?></td>
                  <td><i class="<?= htmlspecialchars($row['icon']) ?>"></i></td>
                  <td><?= htmlspecialchars($row['judul']) ?></td>
                  <td><?= htmlspecialchars($row['deskripsi']) ?></td>
                  <td>
                    <a href="form_keunggulan.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">
                      <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="hapus_keunggulan.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus?')">
                      <i class="fas fa-trash"></i> Hapus
                    </a>
                  </td>
                </tr>
              <?php endwhile; ?>

              <?php if (mysqli_num_rows($keunggulan) === 0): ?>
                <tr>
                  <td colspan="5" class="text-center text-muted">Belum ada data keunggulan.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>