<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}
include '../config/koneksi.php';

// Tambah Data
if (isset($_POST['tambah'])) {
  $nomor = $_POST['nomor'];
  $isi = $_POST['isi'];
  mysqli_query($conn, "INSERT INTO persyaratan (nomor, isi) VALUES ('$nomor', '$isi')");
  header("Location: section_persyaratan.php?success=1");
  exit;
}

// Hapus
if (isset($_GET['hapus'])) {
  $id = $_GET['hapus'];
  mysqli_query($conn, "DELETE FROM persyaratan WHERE id = $id");
  header("Location: section_persyaratan.php?success=1");
  exit;
}

// Ambil data
$data = mysqli_query($conn, "SELECT * FROM persyaratan ORDER BY nomor ASC");

include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Kelola Persyaratan Pendaftaran</h1>
    </div>
  </div>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">

      <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success alert-dismissible">
          <button type="button" class="close" data-dismiss="alert">&times;</button>
          Perubahan berhasil disimpan.
        </div>
      <?php endif; ?>

      <!-- Form tambah -->
      <div class="card mb-4">
        <div class="card-body">
          <form method="post">
            <div class="row">
              <div class="col-md-2">
                <input type="number" name="nomor" class="form-control" placeholder="No." required>
              </div>
              <div class="col-md-8">
                <input type="text" name="isi" class="form-control" placeholder="Isi persyaratan" required>
              </div>
              <div class="col-md-2">
                <button name="tambah" class="btn btn-primary w-100">
                  <i class="fas fa-plus"></i> Tambah
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>

      <!-- Tabel persyaratan -->
      <div class="card">
        <div class="card-body table-responsive">
          <table class="table table-bordered table-striped">
            <thead class="thead-light">
              <tr>
                <th style="width: 50px;">No.</th>
                <th>Persyaratan</th>
                <th style="width: 120px;">Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($data as $row): ?>
                <tr>
                  <td><?= $row['nomor'] ?></td>
                  <td><?= htmlspecialchars($row['isi']) ?></td>
                  <td>
                    <a href="?hapus=<?= $row['id'] ?>" onclick="return confirm('Yakin ingin menghapus data ini?')" class="btn btn-sm btn-danger">
                      <i class="fas fa-trash"></i> Hapus
                    </a>
                  </td>
                </tr>
              <?php endforeach; ?>
              <?php if (mysqli_num_rows($data) == 0): ?>
                <tr>
                  <td colspan="3" class="text-center text-muted">Belum ada data persyaratan.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>