<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';
include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';

// Ambil data setting
$setting = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM setting LIMIT 1"));
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Pengaturan Madrasah</h1>
    </div>
  </div>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">

      <div class="card">
        <div class="card-body">
          <form action="proses_setting.php" method="post" enctype="multipart/form-data">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label>Logo Madrasah</label><br>
                  <?php if ($setting['logo']) : ?>
                    <img src="../uploads/logo/<?= $setting['logo']; ?>" alt="Logo" class="img-thumbnail mb-2" width="120">
                  <?php endif; ?>
                  <input type="file" name="logo" class="form-control">
                  <small class="text-muted">Format: JPG/PNG, Maks 1MB</small>
                </div>
              </div>

              <div class="col-md-8">
                <div class="form-group">
                  <label>Nama Madrasah</label>
                  <input type="text" name="nama_madrasah" value="<?= $setting['nama_madrasah']; ?>" class="form-control" required>
                </div>

                <div class="form-group">
                  <label>Tagline</label>
                  <input type="text" name="tagline" value="<?= $setting['tagline']; ?>" class="form-control">
                </div>

                <div class="form-group">
                  <label>Alamat Madrasah</label>
                  <textarea name="alamat" class="form-control" rows="2"><?= $setting['alamat']; ?></textarea>
                </div>

                <div class="form-group">
                  <label>No. Telepon</label>
                  <input type="text" name="telepon" value="<?= $setting['telepon']; ?>" class="form-control">
                </div>

                <div class="form-group">
                  <label>Email</label>
                  <input type="email" name="email" value="<?= $setting['email']; ?>" class="form-control">
                </div>
              </div>
            </div>

            <hr>
            <h5 class="mt-4">Media Sosial</h5>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Facebook</label>
                  <input type="text" name="facebook" value="<?= $setting['facebook']; ?>" class="form-control">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label>Instagram</label>
                  <input type="text" name="instagram" value="<?= $setting['instagram']; ?>" class="form-control">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label>WhatsApp</label>
                  <input type="text" name="whatsapp" value="<?= $setting['whatsapp']; ?>" class="form-control">
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label>X (Twitter)</label>
                  <input type="text" name="x" value="<?= $setting['x']; ?>" class="form-control">
                </div>
              </div>
            </div>

            <div class="mt-3 text-right">
              <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Simpan Pengaturan
              </button>
            </div>
          </form>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>