<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';

// Proses Simpan
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
  $pertanyaan = mysqli_real_escape_string($conn, $_POST['pertanyaan']);
  $jawaban    = mysqli_real_escape_string($conn, $_POST['jawaban']);

  $query  = "INSERT INTO faq (pertanyaan, jawaban) VALUES ('$pertanyaan', '$jawaban')";
  $result = mysqli_query($conn, $query);

  if ($result) {
    header("Location: faq.php?success=1");
    exit;
  } else {
    $error = "Gagal menambahkan data. " . mysqli_error($conn);
  }
}

include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="d-flex justify-content-between align-items-center">
        <h1 class="m-0">Tambah FAQ</h1>
        <a href="faq.php" class="btn btn-secondary btn-sm">
          <i class="fas fa-arrow-left"></i> Kembali
        </a>
      </div>
    </div>
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <?php if (isset($error)) : ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
          <?= $error ?>
          <button type="button" class="close" data-dismiss="alert" aria-label="Tutup">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      <?php endif; ?>

      <div class="card">
        <div class="card-body">
          <form method="post">
            <div class="form-group">
              <label for="pertanyaan">Pertanyaan</label>
              <input type="text" name="pertanyaan" id="pertanyaan" class="form-control" required>
            </div>
            <div class="form-group">
              <label for="jawaban">Jawaban</label>
              <textarea name="jawaban" id="jawaban" class="form-control" rows="4" required></textarea>
            </div>
            <button type="submit" name="submit" class="btn btn-primary">
              <i class="fas fa-save"></i> Simpan
            </button>
            <a href="faq.php" class="btn btn-secondary ml-2">Batal</a>
          </form>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>