<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';

// Fungsi untuk membuat nama file unik
function generateFileName($extension) {
  $random = substr(md5(uniqid(mt_rand(), true)), 0, 6);
  $tanggal = date("Ymd");
  return "galeri_{$tanggal}_{$random}." . $extension;
}

$folder = '../halaman/assets/img/portofolio/';
$error = '';

if (isset($_POST['submit'])) {
  $file = $_FILES['gambar'];
  $namaAsli = $file['name'];
  $tmp = $file['tmp_name'];
  $ukuran = $file['size'];

  $ext = strtolower(pathinfo($namaAsli, PATHINFO_EXTENSION));
  $allowed = ['jpg', 'jpeg', 'png', 'webp'];

  if (!in_array($ext, $allowed)) {
    $error = "Ekstensi file tidak diperbolehkan. Gunakan JPG, JPEG, PNG, atau WEBP.";
  } elseif ($ukuran > 1 * 1024 * 1024) {
    $error = "Ukuran file maksimal 1MB.";
  } else {
    $namaBaru = generateFileName($ext);
    $target = $folder . $namaBaru;

    if (!is_dir($folder)) {
      mkdir($folder, 0755, true);
    }

    if (move_uploaded_file($tmp, $target)) {
      mysqli_query($conn, "INSERT INTO portofolio (gambar) VALUES ('$namaBaru')");
      header("Location: section_galeri.php?success=1");
      exit;
    } else {
      $error = "Gagal mengunggah gambar.";
    }
  }
}

include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Page Header -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="d-flex justify-content-between align-items-center">
        <h1 class="m-0">Tambah Gambar Galeri</h1>
        <a href="section_galeri.php" class="btn btn-secondary btn-sm">
          <i class="fas fa-arrow-left"></i> Kembali
        </a>
      </div>
    </div>
  </section>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <?php if (!empty($error)) : ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <?= $error ?>
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
          <?php endif; ?>

          <form action="" method="post" enctype="multipart/form-data">
            <div class="form-group">
              <label for="gambar">Pilih Gambar</label>
              <input type="file" name="gambar" class="form-control" id="gambar" required accept=".jpg,.jpeg,.png,.webp">
              <small class="text-muted">Ukuran maksimal 1MB. Format yang diperbolehkan: JPG, JPEG, PNG, WEBP.</small>
            </div>
            <button type="submit" name="submit" class="btn btn-primary">
              <i class="fas fa-upload"></i> Unggah
            </button>
            <a href="section_galeri.php" class="btn btn-secondary ml-2">Batal</a>
          </form>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>