<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}
include '../config/koneksi.php';
include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';

// Handle Hapus
if (isset($_GET['hapus'])) {
  $id = (int) $_GET['hapus'];
  mysqli_query($conn, "DELETE FROM timeline_pendaftaran WHERE id=$id");
  header("Location: timeline_pendaftaran.php?deleted=1");
  exit;
}

// Handle Tambah/Edit
if (isset($_POST['submit'])) {
  $id = $_POST['id'];
  $urutan = $_POST['urutan'];
  $nama = $_POST['nama_kegiatan'];
  $tanggal = $_POST['tanggal'];

  if ($id == '') {
    mysqli_query($conn, "INSERT INTO timeline_pendaftaran (urutan, nama_kegiatan, tanggal) VALUES ('$urutan', '$nama', '$tanggal')");
  } else {
    mysqli_query($conn, "UPDATE timeline_pendaftaran SET urutan='$urutan', nama_kegiatan='$nama', tanggal='$tanggal' WHERE id=$id");
  }
  header("Location: timeline_pendaftaran.php?success=1");
  exit;
}

// Data tampil
$data = mysqli_query($conn, "SELECT * FROM timeline_pendaftaran ORDER BY urutan ASC");
$editData = null;
if (isset($_GET['edit'])) {
  $id = (int) $_GET['edit'];
  $editData = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM timeline_pendaftaran WHERE id=$id"));
}
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Jadwal / Timeline Pendaftaran</h1>
    </div>
  </div>

  <!-- Main Content -->
  <section class="content">
    <div class="container-fluid">

      <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          Data berhasil disimpan.
          <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
      <?php elseif (isset($_GET['deleted'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          Data berhasil dihapus.
          <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
      <?php endif; ?>

      <!-- Form Tambah/Edit -->
      <div class="card card-primary">
        <div class="card-header">
          <h3 class="card-title"><?= $editData ? 'Edit Kegiatan' : 'Tambah Kegiatan' ?></h3>
        </div>
        <form method="post">
          <input type="hidden" name="id" value="<?= $editData['id'] ?? '' ?>">
          <div class="card-body">
            <div class="row">
              <div class="col-md-2">
                <div class="form-group">
                  <label>Urutan</label>
                  <input type="number" name="urutan" class="form-control" required value="<?= $editData['urutan'] ?? '' ?>">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Nama Kegiatan</label>
                  <input type="text" name="nama_kegiatan" class="form-control" required value="<?= $editData['nama_kegiatan'] ?? '' ?>">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Tanggal</label>
                  <input type="text" name="tanggal" class="form-control" required placeholder="Misal: 01 Juli 2025" value="<?= $editData['tanggal'] ?? '' ?>">
                </div>
              </div>
            </div>
          </div>
          <div class="card-footer text-right">
            <button type="submit" name="submit" class="btn btn-primary">
              <i class="fas fa-save"></i> Simpan
            </button>
          </div>
        </form>
      </div>

      <!-- Tabel Data -->
      <div class="card">
        <div class="card-header">
          <h3 class="card-title">Daftar Timeline</h3>
        </div>
        <div class="card-body table-responsive">
          <table class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>Urutan</th>
                <th>Nama Kegiatan</th>
                <th>Tanggal</th>
                <th style="width:120px;">Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php while ($row = mysqli_fetch_assoc($data)): ?>
              <tr>
                <td><?= $row['urutan'] ?></td>
                <td><?= htmlspecialchars($row['nama_kegiatan']) ?></td>
                <td><?= htmlspecialchars($row['tanggal']) ?></td>
                <td>
                  <a href="?edit=<?= $row['id'] ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                  <a href="?hapus=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Hapus data ini?')">
                    <i class="fas fa-trash-alt"></i>
                  </a>
                </td>
              </tr>
              <?php endwhile; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>