<?php
// File: /admin/ubah_status.php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include '../config/koneksi.php';
include 'partials/header.php';
include 'partials/topbar.php';
include 'partials/sidebar.php';

$id = intval($_GET['id']);
$query = mysqli_query($conn, "SELECT * FROM pendaftar WHERE id = $id");
$data = mysqli_fetch_assoc($query);

if (!$data) {
  echo "<script>alert('Data tidak ditemukan'); window.location='data_pendaftar.php';</script>";
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $status = $_POST['status'];
  $update = mysqli_query($conn, "UPDATE pendaftar SET status = '$status' WHERE id = $id");
  if ($update) {
    echo "<script>alert('Status berhasil diubah'); window.location='data_pendaftar.php';</script>";
  } else {
    echo "<script>alert('Gagal mengubah status');</script>";
  }
}
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <!-- Content Header -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="d-flex justify-content-between align-items-center">
        <h1 class="m-0">Ubah Status Pendaftar</h1>
        <a href="data_pendaftar.php" class="btn btn-secondary btn-sm">
          <i class="fas fa-arrow-left"></i> Kembali
        </a>
      </div>
    </div>
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <form method="post">
            <div class="form-group mb-3">
              <label>Nama Pendaftar</label>
              <input type="text" class="form-control" value="<?= htmlspecialchars($data['nama_lengkap']) ?>" readonly>
            </div>
            <div class="form-group mb-3">
              <label>Status Saat Ini</label>
              <input type="text" class="form-control" value="<?= htmlspecialchars($data['status']) ?>" readonly>
            </div>
            <div class="form-group mb-3">
              <label>Ubah Status</label>
              <select name="status" class="form-control" required>
                <option value="">-- Pilih Status --</option>
                <option value="Diterima">Diterima</option>
                <option value="Ditolak">Ditolak</option>
                <option value="Cadangan">Cadangan</option>
              </select>
            </div>
            <div class="mt-4">
              <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Simpan Perubahan
              </button>
              <a href="data_pendaftar.php" class="btn btn-secondary ms-2">Batal</a>
            </div>
          </form>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include 'partials/footer.php'; ?>