<?php
include '../config/koneksi.php';

function formatTanggalIndo($tanggal) {
  $bulan = [
    'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
    'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
  ];
  $tanggalObj = strtotime($tanggal);
  $tgl = date('d', $tanggalObj);
  $bln = $bulan[(int)date('m', $tanggalObj) - 1];
  $thn = date('Y', $tanggalObj);
  return "$tgl $bln $thn";
}

$id = $_GET['id'] ?? 0;
$data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM pendaftar WHERE id='$id'"));

if (!$data || $data['status'] != 'Diterima') {
  echo "<script>alert('Data tidak valid atau belum diterima.'); window.close();</script>";
  exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Formulir Penerimaan</title>
  <style>
    body { font-family: Arial, sans-serif; padding: 40px; }
    .print-area { max-width: 600px; margin: auto; }
    h2 { text-align: center; }
    p { line-height: 1.6; }
  </style>
</head>
<body onload="window.print()">
  <div class="print-area">
    <h2>Formulir Penerimaan Siswa Baru</h2>
    <hr>
    <p><strong>Nama:</strong> <?= htmlspecialchars($data['nama_lengkap']) ?></p>
    <p><strong>Nomor Pendaftaran:</strong> <?= htmlspecialchars($data['nomor_pendaftaran']) ?></p>
    <p><strong>NISN:</strong> <?= htmlspecialchars($data['nisn']) ?></p>
    <p><strong>Tempat & Tgl. Lahir:</strong> <?= htmlspecialchars($data['tempat_lahir']) . ', ' . formatTanggalIndo($data['tanggal_lahir']) ?></p>
    <p><strong>Asal Sekolah:</strong> <?= htmlspecialchars($data['sekolah_asal']) ?></p>
    <hr>
    <p>Selamat! Anda telah dinyatakan diterima sebagai peserta didik baru di madrasah kami.</p>
    <p>Silakan hadir sesuai jadwal dengan membawa dokumen asli.</p>
    <br>
    <p>Panitia PPDB</p>
  </div>
</body>
</html>