<?php
include 'templates/header.php';
include '../config/koneksi.php';

// Ambil pengaturan tanggal pendaftaran
$setting = mysqli_query($conn, "SELECT * FROM setting_pendaftaran LIMIT 1");
$today = date('Y-m-d');

$pendaftaran_dibuka = false;
$pesan_penutupan = "Pendaftaran belum dibuka.";

if ($row = mysqli_fetch_assoc($setting)) {
  $mulai = $row['tanggal_mulai'];
  $selesai = $row['tanggal_selesai'];

  if ($today < $mulai) {
    $pesan_penutupan = "Pendaftaran akan dibuka pada tanggal " . date('d M Y', strtotime($mulai)) . ".";
  } elseif ($today > $selesai) {
    $pesan_penutupan = "Pendaftaran telah ditutup pada tanggal " . date('d M Y', strtotime($selesai)) . ".";
  } else {
    $pendaftaran_dibuka = true;
  }
} else {
  $pesan_penutupan = "Pengaturan jadwal pendaftaran belum tersedia.";
}

if (!$pendaftaran_dibuka):
?>
<section id="pendaftaran-tutup" class="section">
  <div class="container py-5">
    <div class="alert alert-warning text-center shadow-sm p-4 rounded">
      <h4 class="mb-3">Pendaftaran Tidak Tersedia</h4>
      <p class="mb-0"><?= $pesan_penutupan ?></p>
    </div>
  </div>
</section>
<?php
include 'templates/footer.php';
exit;
endif;

// Generate nomor pendaftaran otomatis
$get = mysqli_query($conn, "SELECT MAX(id) as last_id FROM pendaftar");
$row = mysqli_fetch_assoc($get);
$next_id = $row['last_id'] + 1;
$nomor_pendaftaran = 'PMB2025' . str_pad($next_id, 4, '0', STR_PAD_LEFT);
?>

<section id="daftar" class="section">
  <div class="container" data-aos="fade-up">
    <div class="row justify-content-center">
      <div class="col-lg-11 col-xl-10">
        <h2 class="mb-4 text-center fw-bold text-dark fs-4 mt-5 pt-4">Formulir Pendaftaran</h2>
        <div class="bg-white p-4 rounded-3 shadow-sm">
          <form action="../proses/simpan_pendaftaran.php" method="POST" enctype="multipart/form-data">
            <div class="row gy-3">
              <div class="col-md-6">
                <label class="form-label">Nomor Pendaftaran</label>
                <input type="text" name="nomor_pendaftaran" class="form-control form-control-sm" value="<?= $nomor_pendaftaran ?>" readonly>
              </div>
              <div class="col-md-6">
                <label class="form-label">Nama Lengkap</label>
                <input type="text" name="nama_lengkap" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">NISN</label>
                <input type="text" name="nisn" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">NIK</label>
                <input type="text" name="nik" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Tempat Lahir</label>
                <input type="text" name="tempat_lahir" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-3">
                <label class="form-label">Tanggal Lahir</label>
                <input type="date" name="tanggal_lahir" id="tanggal_lahir" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-3">
                <label class="form-label">Usia</label>
                <input type="text" name="usia" id="usia" class="form-control form-control-sm" readonly required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Jenis Kelamin</label>
                <select name="jenis_kelamin" class="form-select form-select-sm" required>
                  <option value="">-- Pilih --</option>
                  <option value="Laki-laki">Laki-laki</option>
                  <option value="Perempuan">Perempuan</option>
                </select>
              </div>
              <div class="col-md-12">
                <label class="form-label">Alamat</label>
                <textarea name="alamat" class="form-control form-control-sm" rows="2" required></textarea>
              </div>
              <div class="col-md-6">
                <label class="form-label">Sekolah Asal</label>
                <input type="text" name="sekolah_asal" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">No HP</label>
                <input type="text" name="no_hp" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Nama Ayah</label>
                <input type="text" name="nama_ayah" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Nama Ibu</label>
                <input type="text" name="nama_ibu" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Pekerjaan Ayah</label>
                <select name="pekerjaan_ayah" class="form-select form-select-sm" required>
                  <option value="">-- Pilih --</option>
                  <option value="Petani">Petani</option>
                  <option value="Pedagang">Pedagang</option>
                  <option value="PNS">PNS</option>
                  <option value="TNI">TNI</option>
                  <option value="Polri">Polri</option>
                  <option value="Wiraswasta">Wiraswasta</option>
                </select>
              </div>
              <div class="col-md-6">
                <label class="form-label">Pekerjaan Ibu</label>
                <select name="pekerjaan_ibu" class="form-select form-select-sm" required>
                  <option value="">-- Pilih --</option>
                  <option value="Petani">Petani</option>
                  <option value="Pedagang">Pedagang</option>
                  <option value="PNS">PNS</option>
                  <option value="TNI">TNI</option>
                  <option value="Polri">Polri</option>
                  <option value="Wiraswasta">Wiraswasta</option>
                </select>
              </div>
              <div class="col-md-6">
                <label class="form-label">Status Ayah</label>
                <select name="status_ayah" class="form-select form-select-sm" required>
                  <option value="">-- Pilih --</option>
                  <option value="Hidup">Hidup</option>
                  <option value="Meninggal">Meninggal</option>
                </select>
              </div>
              <div class="col-md-6">
                <label class="form-label">Status Ibu</label>
                <select name="status_ibu" class="form-select form-select-sm" required>
                  <option value="">-- Pilih --</option>
                  <option value="Hidup">Hidup</option>
                  <option value="Meninggal">Meninggal</option>
                </select>
              </div>
              <!-- Upload -->
              <div class="col-md-6">
                <label class="form-label">Upload Kartu Keluarga</label>
                <input type="file" name="kk" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Upload Akta Kelahiran</label>
                <input type="file" name="akte" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Upload KTP Orang Tua</label>
                <input type="file" name="ktp" class="form-control form-control-sm" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Upload Sertifikat (Opsional)</label>
                <input type="file" name="sertifikat" class="form-control form-control-sm">
              </div>
            </div>

            <div class="form-check mt-4">
              <input class="form-check-input" type="checkbox" required>
              <label class="form-check-label small text-muted">
                Saya menyatakan bahwa data yang saya isikan adalah benar.
              </label>
            </div>

            <div class="text-center mt-4">
              <button type="submit" class="btn btn-primary btn-sm px-4">
                <i class="bi bi-send-fill me-1"></i> Kirim Pendaftaran
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Hitung usia otomatis -->
<script>
  document.getElementById('tanggal_lahir').addEventListener('change', function () {
    const tgl = new Date(this.value);
    const now = new Date();
    let usia = now.getFullYear() - tgl.getFullYear();
    const m = now.getMonth() - tgl.getMonth();
    if (m < 0 || (m === 0 && now.getDate() < tgl.getDate())) {
      usia--;
    }
    document.getElementById('usia').value = usia + ' tahun';
  });
</script>

<?php include 'templates/footer.php'; ?>