<?php include 'templates/header.php'; ?>
<?php
include 'admin/config/koneksi.php';
$about = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM section_about LIMIT 1"));
$cta = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM section_cta LIMIT 1"));
$faq = mysqli_query($conn, "SELECT * FROM faq ORDER BY id ASC");
?>

<!-- ======= Hero Section ======= -->
<section id="hero" class="hero section">
  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row align-items-center mb-5">
      <div class="col-lg-6 mb-4 mb-lg-0">
        <div class="badge-wrapper mb-3">
            <div class="d-inline-flex align-items-center rounded-pill border border-accent-light" style="background-color: rgba(0, 123, 255, 0.1);">
                <div class="icon-circle me-2">
                    <i class="bi bi-bell"></i>
                    </div>
                    <span class="badge-text me-3">Penerimaan Peserta Didik Baru</span>
            </div>
        </div>
        <h1 class="hero-title mb-4">Selamat Datang di PPDB Online</h1>
        <p class="hero-description mb-4">Daftarkan putra-putri terbaik Anda di madrasah kami melalui sistem pendaftaran online yang cepat dan mudah.</p>
        <div class="cta-wrapper">
          <a href="daftar.php" class="btn btn-primary">Daftar Sekarang</a>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="hero-image">
          <img src="assets/img/illustration/illustration-16.webp" alt="PPDB Madrasah" class="img-fluid" loading="lazy">
        </div>
      </div>
    </div>
  </div>
</section>
<!-- ======= End Hero Section ======= -->

<!-- ======= About Section ======= -->
<?php
include 'admin/config/koneksi.php';
$about = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM section_about LIMIT 1"));
?>
<section id="about" class="about section">
  <div class="container">
    <div class="row gy-4">

      <!-- Konten Teks -->
      <div class="col-lg-6 content" data-aos="fade-up" data-aos-delay="100">
        <p class="who-we-are"><?= htmlspecialchars($about['judul_kecil']) ?></p>
        <h3><?= htmlspecialchars($about['judul_besar']) ?></h3>
        <p class="fst-italic"><?= nl2br(htmlspecialchars($about['deskripsi'])) ?></p>
        <ul>
          <?php
          $list = explode("\n", $about['daftar']);
          foreach ($list as $item) {
              echo '<li><i class="bi bi-check-circle"></i> ' . htmlspecialchars(trim($item)) . '</li>';
          }
          ?>
        </ul>
        <a href="#services" class="read-more"><span><?= htmlspecialchars($about['text_link']) ?></span><i class="bi bi-arrow-right"></i></a>
      </div>

      <!-- Gambar About -->
      <div class="col-lg-6 about-images" data-aos="fade-up" data-aos-delay="200">
        <div class="row gy-4">
          <div class="col-lg-6">
  <div style="aspect-ratio: 3/4; overflow: hidden;">
    <img src="/halaman/assets/img/about/<?= htmlspecialchars($about['gambar1']) ?>" class="img-fluid object-fit-cover w-100 h-100" alt="">
  </div>
</div>

          <div class="col-lg-6">
            <div class="row gy-4">
              <div class="col-lg-12">
                <img src="/halaman/assets/img/about/<?= htmlspecialchars($about['gambar2']) ?>" class="img-fluid" alt="">
              </div>
              <div class="col-lg-12">
                <img src="/halaman/assets/img/about/<?= htmlspecialchars($about['gambar3']) ?>" class="img-fluid" alt="">
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>
<!-- ======= End About Section ======= -->

<!-- ======= Services Section ======= -->
<section id="services" class="services section">
  <div class="container section-title" data-aos="fade-up">
    <h2>Keunggulan</h2>
    <p>Alasan memilih madrasah kami untuk pendidikan anak Anda</p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row justify-content-center g-5">
      <?php
      include 'config/koneksi.php';
      $keunggulan = mysqli_query($conn, "SELECT * FROM section_keunggulan");
      $delay = 100;
      $flip = true;

      while ($row = mysqli_fetch_assoc($keunggulan)) :
      ?>
        <div class="col-md-6" data-aos="<?= $flip ? 'fade-right' : 'fade-left' ?>" data-aos-delay="<?= $delay ?>">
          <div class="service-item d-flex flex-column flex-md-row align-items-center align-items-md-start gap-3">
            <div class="service-icon text-center text-md-start">
              <i class="<?= htmlspecialchars($row['icon']) ?>"></i>
            </div>
            <div class="service-content text-center text-md-start">
              <h3><?= htmlspecialchars($row['judul']) ?></h3>
              <p><?= htmlspecialchars($row['deskripsi']) ?></p>
            </div>
          </div>
        </div>
      <?php
        $delay += 100;
        $flip = !$flip;
      endwhile;
      ?>
    </div>
  </div>
</section>
<!-- ======= End Services Section ======= -->

<!-- ======= Galeri Section ======= -->
<section id="portfolio" class="portfolio section">
  <div class="container section-title" data-aos="fade-up">
    <h2>Galeri</h2>
    <p>Kegiatan dan fasilitas madrasah kami</p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row g-4">
      <?php
      include 'admin/config/koneksi.php';
      $galeri = mysqli_query($conn, "SELECT * FROM portofolio ORDER BY id DESC");
      while ($row = mysqli_fetch_assoc($galeri)) :
      ?>
        <div class="col-lg-4 col-md-6">
          <img src="assets/img/portofolio/<?= htmlspecialchars($row['gambar']) ?>" class="img-fluid rounded" alt="Galeri">
        </div>
      <?php endwhile; ?>

      <?php if (mysqli_num_rows($galeri) === 0): ?>
        <div class="col-12">
          <div class="alert alert-info text-center">Belum ada gambar galeri ditampilkan.</div>
        </div>
      <?php endif; ?>
    </div>
  </div>
</section>
<!-- ======= End Galeri Section ======= -->

<!-- ======= Call to Action ======= -->
<section id="call-to-action" class="call-to-action-2 section light-background">
  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="row g-5 align-items-center">
      <div class="col-lg-6" data-aos="fade-right" data-aos-delay="200">
        <img src="assets/img/cta/<?= $cta['gambar'] ?>" class="img-fluid rounded-4" alt="">
      </div>
      <div class="col-lg-6" data-aos="fade-left" data-aos-delay="300">
        <div class="cta-content">
          <h2><?= htmlspecialchars($cta['judul']) ?></h2>
          <p class="lead"><?= nl2br(htmlspecialchars($cta['deskripsi'])) ?></p>
          <div class="cta-action mt-4">
            <a href="<?= htmlspecialchars($cta['link']) ?>" class="btn btn-primary btn-lg">Isi Formulir PPDB</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- ======= End Call to Action ======= -->

<!-- ======= FAQ Section (Gantikan Kontak) ======= -->
<section id="faq" class="faq section">
  <div class="container section-title" data-aos="fade-up">
    <h2>Pertanyaan Umum</h2>
    <p>Temukan jawaban atas pertanyaan yang sering diajukan</p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100">
    <div class="accordion accordion-flush" id="faqAccordion">
      <?php $i = 1; while ($row = mysqli_fetch_assoc($faq)) : ?>
        <div class="accordion-item border-bottom mb-3">
          <h2 class="accordion-header" id="faqHeading<?= $i ?>">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse<?= $i ?>" aria-expanded="false" aria-controls="faqCollapse<?= $i ?>">
              <?= htmlspecialchars($row['pertanyaan']) ?>
            </button>
          </h2>
          <div id="faqCollapse<?= $i ?>" class="accordion-collapse collapse" aria-labelledby="faqHeading<?= $i ?>" data-bs-parent="#faqAccordion">
            <div class="accordion-body">
              <?= nl2br(htmlspecialchars($row['jawaban'])) ?>
            </div>
          </div>
        </div>
      <?php $i++; endwhile; ?>
    </div>
  </div>
</section>
<!-- ======= End FAQ Section ======= -->

<?php include 'templates/footer.php'; ?>