<?php
include '../config/koneksi.php';
include 'templates/header.php'; // Header Invent
?>

<main id="main">
  <!-- ======= Pengumuman Section ======= -->
  <section class="section bg-light">
    <div class="container" data-aos="fade-up">
      <div class="section-title text-center">
          <br><br><br><br><br><br>
          <h2>Pengumuman</h2>
        <p>Cari tahu hasil seleksi Anda berdasarkan Nomor Pendaftaran, Nama, atau NISN</p>
      </div>

      <div class="row justify-content-center">
        <div class="col-lg-8">
          <form method="GET" class="text-center mb-4">
            <input type="text" name="keyword" class="form-control text-center" placeholder="Masukkan Nomor Pendaftaran / Nama / NISN" required>
            <button type="submit" class="btn btn-primary mt-3">Cek Hasil</button>
          </form>

          <?php if (isset($_GET['keyword'])): ?>
            <?php
            $keyword = mysqli_real_escape_string($conn, $_GET['keyword']);
            $query = mysqli_query($conn, "SELECT * FROM pendaftar 
              WHERE nomor_pendaftaran = '$keyword' 
              OR nama_lengkap LIKE '%$keyword%' 
              OR nisn = '$keyword' LIMIT 1");
            $data = mysqli_fetch_assoc($query);

            $pengaturan = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM pengaturan_pengumuman LIMIT 1"));
            $link_wa = $pengaturan['link_grup_wa'] ?? '#';
            $nomor_panitia = $pengaturan['nomor_panitia'] ?? '08XXXXXXXX';

            if ($data):
              if ($data['status'] == 'Diterima'): ?>
                <div class="alert alert-success text-center mt-4">
                  <h4 class="mb-3">🎉 Selamat, Anda <strong>DITERIMA</strong>!</h4>
                  <p class="mb-4">Silakan cetak formulir penerimaan dan gabung grup WhatsApp untuk informasi selanjutnya.</p>
                  <div class="d-flex justify-content-center gap-3">
                    <a href="cetak_penerimaan.php?id=<?= $data['id'] ?>" class="btn btn-success" target="_blank">Cetak Formulir</a>
                    <a href="<?= $link_wa ?>" target="_blank" class="btn btn-outline-primary">Gabung Grup WhatsApp</a>
                  </div>
                </div>
              <?php else: ?>
                <div class="alert alert-danger text-center mt-4">
                  <h4 class="mb-3">😔 Maaf, Anda <strong>belum diterima</strong></h4>
                  <p class="mb-4">Silakan hubungi panitia untuk info lebih lanjut.</p>
                  <a href="https://wa.me/<?= $nomor_panitia ?>" target="_blank" class="btn btn-danger">Hubungi Panitia</a>
                </div>
              <?php endif;
            else: ?>
              <div class="alert alert-warning text-center mt-4">Data tidak ditemukan. Periksa kembali isian Anda.</div>
            <?php endif; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </section>
  <!-- End Pengumuman Section -->
</main>

<?php include 'templates/footer.php'; ?>