<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

include '../config/koneksi.php';

// Folder tujuan upload
$upload_dir = '../uploads/';

// Fungsi bantu upload
function upload_file($input_name, $upload_dir) {
  if (isset($_FILES[$input_name]) && $_FILES[$input_name]['error'] === UPLOAD_ERR_OK) {
    $ext = pathinfo($_FILES[$input_name]['name'], PATHINFO_EXTENSION);
    $filename = uniqid($input_name . "_") . '.' . $ext;
    $destination = $upload_dir . $filename;
    if (move_uploaded_file($_FILES[$input_name]['tmp_name'], $destination)) {
      return $filename;
    }
  }
  return null;
}

// Pastikan semua field POST tersedia
$required_fields = [
  'nomor_pendaftaran', 'nama_lengkap', 'nisn', 'nik', 'tempat_lahir', 'tanggal_lahir',
  'usia', 'jenis_kelamin', 'alamat', 'sekolah_asal', 'no_hp',
  'nama_ayah', 'nama_ibu', 'pekerjaan_ayah', 'pekerjaan_ibu', 'status_ayah', 'status_ibu'
];

foreach ($required_fields as $field) {
  if (!isset($_POST[$field])) {
    die("Field '$field' tidak ditemukan.");
  }
}

// Ambil data dari form dan escape
$nomor_pendaftaran = mysqli_real_escape_string($conn, $_POST['nomor_pendaftaran']);
$nama_lengkap      = mysqli_real_escape_string($conn, $_POST['nama_lengkap']);
$nisn              = mysqli_real_escape_string($conn, $_POST['nisn']);
$nik               = mysqli_real_escape_string($conn, $_POST['nik']);
$tempat_lahir      = mysqli_real_escape_string($conn, $_POST['tempat_lahir']);
$tanggal_lahir     = mysqli_real_escape_string($conn, $_POST['tanggal_lahir']);
$birthDate = new DateTime($_POST['tanggal_lahir']);
$today = new DateTime();
$diff = $today->diff($birthDate);
$usia = $diff->y . ' tahun';
$jenis_kelamin     = mysqli_real_escape_string($conn, $_POST['jenis_kelamin']);
$alamat            = mysqli_real_escape_string($conn, $_POST['alamat']);
$sekolah_asal      = mysqli_real_escape_string($conn, $_POST['sekolah_asal']);
$no_hp             = mysqli_real_escape_string($conn, $_POST['no_hp']);
$nama_ayah         = mysqli_real_escape_string($conn, $_POST['nama_ayah']);
$nama_ibu          = mysqli_real_escape_string($conn, $_POST['nama_ibu']);
$pekerjaan_ayah    = mysqli_real_escape_string($conn, $_POST['pekerjaan_ayah']);
$pekerjaan_ibu     = mysqli_real_escape_string($conn, $_POST['pekerjaan_ibu']);
$status_ayah       = mysqli_real_escape_string($conn, $_POST['status_ayah']);
$status_ibu        = mysqli_real_escape_string($conn, $_POST['status_ibu']);

// Upload file
$file_kk         = upload_file('kk', $upload_dir);
$file_akte       = upload_file('akte', $upload_dir);
$file_ktp        = upload_file('ktp', $upload_dir);
$file_sertifikat = upload_file('sertifikat', $upload_dir); // opsional

// Validasi upload wajib
if (!$file_kk || !$file_akte || !$file_ktp) {
  die("❌ Upload file wajib gagal. Pastikan file KK, Akta, dan KTP telah dipilih dan ukurannya sesuai.");
}

// Simpan ke database
$sql = "INSERT INTO pendaftar (
  nomor_pendaftaran, nama_lengkap, nisn, nik, tempat_lahir, tanggal_lahir, usia, jenis_kelamin, alamat,
  sekolah_asal, no_hp, nama_ayah, nama_ibu, pekerjaan_ayah, pekerjaan_ibu, status_ayah, status_ibu,
  file_kk, file_akte, file_ktp, file_sertifikat
) VALUES (
  '$nomor_pendaftaran', '$nama_lengkap', '$nisn', '$nik', '$tempat_lahir', '$tanggal_lahir', '$usia', '$jenis_kelamin', '$alamat',
  '$sekolah_asal', '$no_hp', '$nama_ayah', '$nama_ibu', '$pekerjaan_ayah', '$pekerjaan_ibu', '$status_ayah', '$status_ibu',
  '$file_kk', '$file_akte', '$file_ktp', '$file_sertifikat'
)";

// Proses simpan
if (mysqli_query($conn, $sql)) {
  $last_id = mysqli_insert_id($conn);
  header("Location: ../halaman/cetak_bukti.php?id=" . $last_id);
  exit;
} else {
  echo "❌ Gagal menyimpan data:<br>" . mysqli_error($conn) . "<br><br>";
  echo "Query SQL:<br>" . $sql;
}
?>